//$Id: CPolygon.cpp,v 1.6 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CPolygon.hpp"
using Exponent::MathTools::CPolygon;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CPolygon, CCountedObject);

//	===========================================================================
CPolygon::CPolygon(const long numberOfPoints) : m_pointArray(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CPolygon);

	// Create the array
	m_pointArray = new TCountedPointerArray<CPoint>;

	// Now initialise
	this->initialiseArray(numberOfPoints);
}

//	===========================================================================
CPolygon::CPolygon(const CPolygon &polygon) : m_pointArray(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CPolygon);

	// Create the array
	m_pointArray = new TCountedPointerArray<CPoint>;

	// Now copy
	*this = polygon;
}

//	===========================================================================
CPolygon::CPolygon() : m_pointArray(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CPolygon);

	// Create the array
	m_pointArray = new TCountedPointerArray<CPoint>;

	// Dont initialise
}

//	===========================================================================
CPolygon::~CPolygon()
{
	EXPONENT_CLASS_DESTRUCTION(CPolygon);
	FREE_POINTER(m_pointArray);
}

//	===========================================================================
CPolygon &CPolygon::operator = (const CPolygon &polygon)
{
	// Check if we have pointers
	if (m_pointArray->getArraySize() != polygon.getNumberOfPoints())
	{
		this->initialiseArray(polygon.getNumberOfPoints());
	}

	// Now loop through the array
	for (long i = 0; i < m_pointArray->getArraySize(); i++)
	{
		// Get the two points
		CPoint *thisPoint  = m_pointArray->elementAtIndex(i);
		CPoint *otherPoint = polygon.m_pointArray->elementAtIndex(i);

		// If we have two valid pointers
		if (thisPoint && otherPoint)
		{
			// Then copy them..
			*thisPoint = *otherPoint;
		}
	}

	return *this;
}

//	===========================================================================
bool CPolygon::operator == (const CPolygon &polygon)
{
	// Check they are the same size
	if (m_pointArray->getArraySize() != polygon.getNumberOfPoints())
	{
		return false;
	}

	// Loop through the array
	for (long i = 0; i < m_pointArray->getArraySize(); i++)
	{
		// Get the two pointers
		CPoint *thisPoint  = m_pointArray->elementAtIndex(i);
		CPoint *otherPoint = polygon.m_pointArray->elementAtIndex(i);

		// Check they are valid
		if (thisPoint && otherPoint)
		{
			// If they are not equal then the polygon is not equal
			if (!(*thisPoint == *otherPoint))
			{
				return false;
			}
		}
	}
	return true;
}

//	===========================================================================
void CPolygon::setPoint(const CPoint &point, const long index)
{
	// Get the pointer
	CPoint *thisPoint = m_pointArray->elementAtIndex(index);

	// Check if its valid
	if (thisPoint)
	{
		// Copy it
		*thisPoint = point;
	}
}

//	===========================================================================
CPoint *CPolygon::getPoint(const long index)
{
	return m_pointArray->elementAtIndex(index);
}

//	===========================================================================
void CPolygon::initialiseArray(const long numberOfPoints)
{
	// Delete the old array
	m_pointArray->clearArray();

	// Now add the elements
	for (long i = 0; i < numberOfPoints; i++)
	{
		m_pointArray->addElement(new CPoint());
	}
}

//	===========================================================================
long CPolygon::getNumberOfPoints() const
{
	return m_pointArray->getInsertIndex();
}

//	===========================================================================
void CPolygon::offset(const CPoint &point)
{
	// Loop through the array
	for (long i = 0; i < m_pointArray->getArraySize(); i++)
	{
		// Get the pointer
		CPoint *thisPoint = m_pointArray->elementAtIndex(i);

		// Check its valid
		if (thisPoint)
		{
			// Offset the position
			thisPoint->offset(point);
		}
	}
}